# 排序

Joe 需要根据员工表

```sql
create table employee
(
    id     serial primary key,
    name   varchar(256),
    dept   varchar(256),
    salary decimal(12, 4)
);
```

生成一份报表，首先按部门名称的字典序排序，部门内部按员工工资从高到低排列，那么这个查询应该是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select id, name, dept, salary from employee order by dept, salary desc;
```

## 选项

### A

```sql
select id, name, dept, salary from employee order by dept, salary;
```

### B

```sql
select id, name, dept, salary from employee order by dept desc, salary desc;
```

### C
```sql
select id, name, dept, salary from employee order by dept and salary desc;
```

### D

```sql
select id, name, dept, salary from employee order by dept, salary, id, name;
```

### E
```sql
select id, name, dept, salary from employee order by dept, salary desc;
```

